import React, { useState } from 'react';
import { Header } from './components/layout/Header';
import { Footer } from './components/layout/Footer';
import { Hero } from './components/sections/Hero';
import { Features } from './components/sections/Features';
import { HowItWorks } from './components/sections/HowItWorks';
import { CtaSection } from './components/sections/CtaSection';
import { Dashboard } from './components/dashboard/Dashboard';
import { ScriptLibrary } from './components/dashboard/ScriptLibrary';

export type ViewState = 'landing' | 'dashboard' | 'library';

const App: React.FC = () => {
  const [currentView, setCurrentView] = useState<ViewState>('landing');

  const handleNavigate = (view: ViewState) => {
    window.scrollTo({ top: 0, behavior: 'smooth' });
    setCurrentView(view);
  };

  return (
    <div className="min-h-screen flex flex-col bg-slate-50 text-slate-900 selection:bg-purple-500 selection:text-white">
      <Header currentView={currentView} onNavigate={handleNavigate} />
      
      <main className="flex-grow relative">
        {/* Background Gradients */}
        <div className="fixed inset-0 z-0 pointer-events-none overflow-hidden">
            <div className="absolute top-[-10%] right-[-10%] w-[500px] h-[500px] bg-purple-600/10 rounded-full blur-[120px]" />
            <div className="absolute bottom-[-10%] left-[-10%] w-[500px] h-[500px] bg-blue-600/10 rounded-full blur-[120px]" />
        </div>

        <div className="relative z-10">
          {currentView === 'landing' && (
            <>
              <Hero onGetStarted={() => handleNavigate('dashboard')} />
              <Features />
              <HowItWorks />
              <CtaSection onGetStarted={() => handleNavigate('dashboard')} />
            </>
          )}

          {currentView === 'dashboard' && (
            <Dashboard onNavigate={handleNavigate} />
          )}

          {currentView === 'library' && (
            <ScriptLibrary />
          )}
        </div>
      </main>

      <Footer />
    </div>
  );
};

export default App;