import React, { useState } from 'react';
import { ScrollText, Github, Twitter, Linkedin } from 'lucide-react';

export const Footer: React.FC = () => {
  return (
    <footer className="bg-white border-t border-slate-200 pt-16 pb-8">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-12 mb-12">
          {/* Brand */}
          <div className="col-span-1 md:col-span-1">
            <div className="flex items-center gap-2 mb-4">
              <div className="w-8 h-8 rounded-lg bg-gradient-to-br from-purple-600 to-blue-600 flex items-center justify-center">
                <ScrollText className="text-white w-5 h-5" />
              </div>
              <span className="text-lg font-bold text-slate-900">Autom8</span>
            </div>
            <p className="text-slate-500 text-sm leading-relaxed mb-6">
              مدیریت هوشمند اسکریپت‌های Google Apps Script. 
              ایجاد، مدیریت و اجرای اسکریپت‌های قدرتمند با یک کلیک.
            </p>
            <div className="flex gap-4">
              <a href="#" className="text-slate-400 hover:text-slate-800 transition-colors"><Github className="w-5 h-5" /></a>
              <a href="#" className="text-slate-400 hover:text-blue-400 transition-colors"><Twitter className="w-5 h-5" /></a>
              <a href="#" className="text-slate-400 hover:text-blue-600 transition-colors"><Linkedin className="w-5 h-5" /></a>
            </div>
          </div>

          {/* Links */}
          <div>
            <h3 className="text-slate-900 font-bold mb-4">محصول</h3>
            <ul className="space-y-2 text-slate-500 text-sm">
              <li><a href="#" className="hover:text-purple-600 transition-colors">ویژگی‌ها</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">قیمت‌ها</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">API</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">ادغام Drive</a></li>
            </ul>
          </div>

          <div>
            <h3 className="text-slate-900 font-bold mb-4">منابع</h3>
            <ul className="space-y-2 text-slate-500 text-sm">
              <li><a href="#" className="hover:text-purple-600 transition-colors">مستندات</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">راهنما</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">وبلاگ</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">جامعه کاربری</a></li>
            </ul>
          </div>

          <div>
            <h3 className="text-slate-900 font-bold mb-4">قانونی</h3>
            <ul className="space-y-2 text-slate-500 text-sm">
              <li><a href="#" className="hover:text-purple-600 transition-colors">حریم خصوصی</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">قوانین استفاده</a></li>
              <li><a href="#" className="hover:text-purple-600 transition-colors">امنیت</a></li>
            </ul>
          </div>
        </div>

        <div className="border-t border-slate-200 pt-8 text-center">
          <p className="text-slate-500 text-sm">
            © ۲۰۲۵ Autom8. تمامی حقوق محفوظ است. طراحی شده با ❤️ و ☕
          </p>
        </div>
      </div>
    </footer>
  );
};