# 🔧 راهنمای تنظیم Environment Variables

برای اجرای صحیح پروژه، فایل `.env.local` را در ریشه پروژه ایجاد کنید و متغیرهای زیر را تنظیم کنید:

```env
# Google Apps Script Configuration
NEXT_PUBLIC_GOOGLE_APPS_SCRIPT_URL=
GOOGLE_APPS_SCRIPT_WEB_APP_URL=

# Application Configuration
NEXT_PUBLIC_APP_URL=https://taskflow.madebypersians.ir
PORT=6830
NODE_ENV=production

# API Configuration (if needed)
API_SECRET_KEY=
```

## 📝 توضیحات متغیرها:

- `NEXT_PUBLIC_GOOGLE_APPS_SCRIPT_URL`: آدرس Web App از Google Apps Script
- `GOOGLE_APPS_SCRIPT_WEB_APP_URL`: آدرس کامل Web App (برای استفاده در Backend)
- `NEXT_PUBLIC_APP_URL`: آدرس اصلی اپلیکیشن
- `PORT`: پورت اجرای سرور (پیش‌فرض: 6830)
- `NODE_ENV`: محیط اجرا (development/production)
- `API_SECRET_KEY`: کلید امنیتی برای API (اختیاری)

## 🚀 نحوه اجرا:

```bash
# نصب وابستگی‌ها
npm install

# اجرای Development
npm run dev

# Build برای Production
npm run build

# اجرای Production
npm start
```

پروژه روی پورت **6830** اجرا می‌شود.

