# 📝 TaskFlow

پلتفرم مدیریت تسک‌ها با Google Apps Script

## 🚀 شروع سریع

### نصب وابستگی‌ها

```bash
npm install
```

### تنظیم Environment Variables

فایل `.env.local` را در ریشه پروژه ایجاد کنید و متغیرهای مورد نیاز را تنظیم کنید. برای جزئیات بیشتر به فایل `ENV_SETUP.md` مراجعه کنید.

```env
NEXT_PUBLIC_APP_URL=https://taskflow.madebypersians.ir
PORT=6830
NODE_ENV=production
```

### اجرای Development

```bash
npm run dev
```

پروژه روی آدرس [http://localhost:6830](http://localhost:6830) اجرا می‌شود.

### Build برای Production

```bash
npm run build
npm start
```

## 📁 ساختار پروژه

```
autom8/
├── app/
│   ├── page.tsx          # صفحه اصلی
│   ├── layout.tsx        # Layout اصلی
│   └── globals.css       # استایل‌های全局
├── public/               # فایل‌های استاتیک
├── server.js             # سرور Node.js برای standalone mode
├── next.config.ts        # تنظیمات Next.js
└── package.json          # وابستگی‌ها و اسکریپت‌ها
```

## 🔗 اتصال به Google Apps Script

برای اتصال به Google Apps Script:

1. کد `Code.gs` را در Google Apps Script Save کنید
2. به **"Deploy" → "Manage deployments"** بروید
3. روی **✏️ Edit** کلیک کنید
4. Version را به **"New version"** تغییر دهید
5. **"Who has access"** را روی **"Anyone"** تنظیم کنید
6. روی **"Deploy"** کلیک کنید
7. URL را در متغیر `NEXT_PUBLIC_GOOGLE_APPS_SCRIPT_URL` قرار دهید

## 🌐 Deploy

پروژه برای اجرا روی پورت **6830** و آدرس **https://taskflow.madebypersians.ir** تنظیم شده است.

## 📚 مستندات بیشتر

برای اطلاعات بیشتر در مورد تنظیمات Environment Variables، به فایل `ENV_SETUP.md` مراجعه کنید.

---

© 2025 TaskFlow - تمامی حقوق محفوظ است
