import React from 'react';
import { GlassCard } from '../ui/GlassCard';
import { SCRIPT_TEMPLATES } from '@/lib/constants';
import { PenTool, Palette, BarChart, Search, MapPin, Container, BookOpen, FolderTree, ArrowLeft } from 'lucide-react';

// Map string icon names to components
const IconMap: Record<string, React.ElementType> = {
  PenTool, Palette, BarChart, Search, MapPin, Container, BookOpen, FolderTree
};

export const Features: React.FC = () => {
  return (
    <section className="py-20 relative bg-slate-50/50">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-5xl font-bold text-slate-900 mb-4">
            ابزارهای قدرتمند برای
            <span className="text-purple-600 mr-2">رشد شما</span>
          </h2>
          <p className="text-slate-600 text-lg max-w-2xl mx-auto">
            مجموعه‌ای از اسکریپت‌های آماده و بهینه شده برای خودکارسازی کارهای روزمره
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
          {SCRIPT_TEMPLATES.map((script) => {
            const Icon = IconMap[script.iconName] || PenTool;
            return (
              <GlassCard key={script.id} hoverEffect className="p-6 flex flex-col h-full group cursor-pointer">
                <div className="w-12 h-12 rounded-xl bg-purple-100 flex items-center justify-center mb-6 group-hover:bg-purple-200 transition-colors">
                  <Icon className="w-6 h-6 text-purple-600 group-hover:text-purple-700" />
                </div>
                
                <h3 className="text-xl font-bold text-slate-900 mb-2">{script.title}</h3>
                <p className="text-slate-600 text-sm mb-6 flex-grow leading-relaxed">
                  {script.description}
                </p>

                <div className="flex items-center text-purple-600 text-sm font-medium group-hover:text-purple-700 mt-auto">
                  ادامه مطلب
                  <ArrowLeft className="w-4 h-4 mr-2 transition-transform group-hover:-translate-x-1" />
                </div>
              </GlassCard>
            );
          })}
        </div>
      </div>
    </section>
  );
};

