'use client';

import React from 'react';
import { Button } from '../ui/Button';
import { Play, ArrowLeft } from 'lucide-react';
import { GlassCard } from '../ui/GlassCard';
import Link from 'next/link';

export const Hero: React.FC = () => {
  return (
    <section className="relative pt-32 pb-20 md:pt-48 md:pb-32 overflow-hidden">
      <div className="container mx-auto px-4">
        <div className="flex flex-col items-center text-center max-w-4xl mx-auto z-10 relative">
          
          {/* Badge */}
          <div className="inline-flex items-center gap-2 px-3 py-1 rounded-full bg-purple-50 border border-purple-200 text-purple-600 text-sm mb-8 animate-pulse">
            <span className="relative flex h-2 w-2">
              <span className="animate-ping absolute inline-flex h-full w-full rounded-full bg-purple-400 opacity-75"></span>
              <span className="relative inline-flex rounded-full h-2 w-2 bg-purple-600"></span>
            </span>
            نسخه جدید ۲.۰ با هوش مصنوعی Gemini فعال شد
          </div>

          {/* Headline */}
          <h1 className="text-4xl md:text-6xl lg:text-7xl font-bold tracking-tight text-slate-900 mb-6 leading-tight">
            مدیریت هوشمند اسکریپت‌های
            <br />
            <span className="text-transparent bg-clip-text bg-gradient-to-r from-purple-600 via-blue-600 to-purple-600 animate-gradient-x">
              Google Apps Script
            </span>
          </h1>

          {/* Subheadline */}
          <p className="text-lg md:text-xl text-slate-600 mb-10 max-w-2xl leading-relaxed">
            ایجاد، مدیریت و اجرای اسکریپت‌های قدرتمند با یک کلیک. 
            فرآیندهای تکراری خود را با کمک هوش مصنوعی و ابزارهای پیشرفته Autom8 خودکار کنید.
          </p>

          {/* Buttons */}
          <div className="flex flex-col sm:flex-row gap-4 w-full sm:w-auto">
            <Link href="/dashboard">
              <Button size="lg">
                شروع رایگان
                <ArrowLeft className="mr-2 w-5 h-5" />
              </Button>
            </Link>
            <Button size="lg" variant="outline">
              مشاهده دمو
              <Play className="mr-2 w-5 h-5 fill-current" />
            </Button>
          </div>

          {/* Floating Code Mockup */}
          <div className="mt-20 w-full relative perspective-1000">
            <GlassCard className="p-4 md:p-6 transform rotate-x-12 shadow-2xl shadow-purple-500/10 border-slate-200 bg-slate-900 text-left mx-auto max-w-4xl">
              <div className="flex items-center gap-2 mb-4 border-b border-white/10 pb-4">
                <div className="flex gap-1.5">
                  <div className="w-3 h-3 rounded-full bg-red-500"></div>
                  <div className="w-3 h-3 rounded-full bg-yellow-500"></div>
                  <div className="w-3 h-3 rounded-full bg-green-500"></div>
                </div>
                <div className="ml-4 text-xs text-slate-500 font-mono">content-generator.gs</div>
              </div>
              <div className="text-left font-mono text-sm md:text-base space-y-1 overflow-x-auto dir-ltr">
                <div className="text-purple-400">function <span className="text-blue-400">generateContent</span>() {'{'}</div>
                <div className="pl-4 text-slate-300">const <span className="text-yellow-300">doc</span> = DocumentApp.create(<span className="text-green-400">'New AI Post'</span>);</div>
                <div className="pl-4 text-slate-300">const <span className="text-yellow-300">body</span> = doc.getBody();</div>
                <div className="pl-4 text-slate-500">// Connected to Gemini API via Autom8</div>
                <div className="pl-4 text-slate-300">const <span className="text-yellow-300">content</span> = Autom8.<span className="text-blue-400">askAI</span>(<span className="text-green-400">'Write a blog about React'</span>);</div>
                <div className="pl-4 text-slate-300">body.appendParagraph(content);</div>
                <div className="text-purple-400">{'}'}</div>
              </div>
            </GlassCard>
            
            {/* Decorative Glows */}
            <div className="absolute -top-20 -right-20 w-72 h-72 bg-purple-500/20 rounded-full blur-[100px] -z-10"></div>
            <div className="absolute -bottom-20 -left-20 w-72 h-72 bg-blue-500/20 rounded-full blur-[100px] -z-10"></div>
          </div>

        </div>
      </div>
    </section>
  );
};

