import React from 'react';

interface GlassCardProps {
  children: React.ReactNode;
  className?: string;
  hoverEffect?: boolean;
}

export const GlassCard: React.FC<GlassCardProps> = ({ 
  children, 
  className = '', 
  hoverEffect = false 
}) => {
  return (
    <div className={`
      relative overflow-hidden
      bg-white/60 backdrop-blur-md 
      border border-white/60 
      shadow-sm shadow-slate-200/50
      rounded-2xl 
      transition-all duration-300
      ${hoverEffect ? 'hover:bg-white/80 hover:scale-[1.02] hover:shadow-xl hover:shadow-purple-500/10 hover:border-purple-500/20' : ''}
      ${className}
    `}>
      {children}
    </div>
  );
};

