import { LucideIcon } from 'lucide-react';

export interface ScriptTemplate {
  id: string;
  title: string;
  description: string;
  iconName: string; // We store the name to map to Lucide icons
  category: 'AI' | 'SEO' | 'Data' | 'Utilities' | 'Maps';
  popular?: boolean;
}

export interface FeatureItem {
  id: string;
  title: string;
  description: string;
  icon: LucideIcon;
}

export interface NavItem {
  label: string;
  href: string;
  action?: boolean;
}

export interface StatCardProps {
  title: string;
  value: string;
  icon: LucideIcon;
  trend?: string;
  trendUp?: boolean;
}

